// This is the main DLL file.

#using "CSharp.dll"

#include "stdafx.h"
#include "CppWrapper.h"
#include <msclr\auto_gcroot.h>

using namespace System::Runtime::InteropServices; // Marshal

class CppWrapperPrivate
{
public: msclr::auto_gcroot<CSharp^> csharp;
};

CppWrapper::CppWrapper()
{
	_private = new CppWrapperPrivate();
	_private->csharp = gcnew CSharp();
}

void CppWrapper::CppWExcelComms(char* OpenFileName, char* SheetName, char* SaveFileName, long* int_vec, double* xx)
{

	// copy unmanaged character variables to managed variables
	System::String^ _OpenFileName = gcnew System::String(OpenFileName);
	System::String^ _SheetName = gcnew System::String(SheetName);
	System::String^ _SaveFileName = gcnew System::String(SaveFileName);

	// copy unmanaged integer array to managed array
	array<__int32>^ _int_vec = gcnew array<__int32>(6);
	Marshal::Copy(System::IntPtr((void *)int_vec), _int_vec, 0, 6);

	// copy unmanaged real array to managed array
	int temp = int_vec[2] * int_vec[3];
	array<double>^ _xx = gcnew array<double>(temp);
	Marshal::Copy(System::IntPtr((void *)xx), _xx, 0, temp);

	// run C# routine
	_private->csharp->CSExcelComms(_OpenFileName, _SheetName, _SaveFileName, _int_vec, _xx);

	// if read, then recover managed array to unmanaged array
	if ( int_vec[4]==1) Marshal::Copy(_xx, 0, System::IntPtr((void *)xx), temp);

	// exit wrapper
	return;
}

CppWrapper::~CppWrapper()
{
	delete _private;
}

/*

For details about copying data between managed and unmanaged code, see:
https://msdn.microsoft.com/en-us/library/system.runtime.interopservices.marshal_methods(v=vs.110).aspx

Structure of approach based on: http://pragmateek.com/using-c-from-native-c-with-the-help-of-ccli-v2/
System::String is not meant to be CLI compliant, and this may result in errors in the future.

*/
